#Define the derivative of a polynomial
def D(f):
    D = [0]*len(f)
    for i in range(len(f)):
        D[i] = i*f[i]
    D.pop(0)
    return D

#Evaluating a polynomial
def poly(f, x):
    ans=0
    for i in range(len(f)):
        ans += f[i]*x**i
    return ans

#Apply newtons method to a polynomial to find a root
def newton(f, x0, epsilon):
    xn = x0
    for n in range(0, 10**6):
        fxn = poly(f, xn)
        if abs(fxn)<epsilon:
            return xn
        Df = D(f)
        Dfxn = poly(Df, xn)
#If the derivative of your polynomial is zero somewhere, because you chose x0 unwisely, you could try the following below as well (import random).
#        if Dfxn == 0:
#            x0 = random.randint(0, 100)
#            return newton(f, x0, epsilon)
        xn = xn - fxn/Dfxn
    print('Error, exceeded maximum iterations')
    return None

#Divide a polynomial f by a root x
def zerodivisor(f, x):
    g = f
    ans = [0]*(len(f)-1)
    for i in range(len(f)-1):
        ele = g[-1]
        ans[-i-1] = ele
        g.pop()
        g[-1] += ele*x**len(g)
    return ans

def zerolist(f, x0, epsilon):
    list=[0]*(len(f)-1)
    g=f
    for i in range(len(f)-1):
        zero = newton(g, x0, epsilon)
        list[i] = zero
        g = zerodivisor(g, zero)
    return list

degree = input()
p = list(map(float, input().split()))
print(sorted(zerolist(p, 0.001, 10**-6))) #For part A, you should round the results to integers first
